from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Turn on the light (execute_push_switch)
        # The skill function for execute_push_switch is not mapped to execute_movement,
        # so we call it directly from primitive_skill.
        robot.primitive_skill.execute_push_switch("light_switch", "ready-pose")

        # Step 2: Pick the bottom handle (execute_pick)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the bottom drawer (execute_pull)
        # Use the handle object for pulling, approach along x-axis, set distance for pull
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()