# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We need to explore the environment to confirm the robot's location and available predicates.

        # Try to use available skills to explore the environment and check for the missing predicate.
        # Since we cannot define new skills, we use the available ones to move and observe.

        # Step 1: Try to use 'execute_go' to move the robot to 'floor' (if such a location exists)
        # Step 2: After moving, check if the robot is at 'floor' (simulate predicate check)
        # Step 3: If not possible, try to use other skills to explore

        # For demonstration, we will attempt to move the robot to all known locations and print the result.
        # This helps to identify if (robot-at floor) is a valid predicate in the environment.

        # Get all location names from positions (assuming keys are object/location names)
        location_names = []
        for name, pos in positions.items():
            if 'floor' in name.lower() or 'room' in name.lower() or 'drawer' in name.lower() or 'table' in name.lower():
                location_names.append(name)
        # If no locations found, fallback to all keys
        if not location_names:
            location_names = list(positions.keys())

        # Try to move the robot to each location using execute_go
        # Since execute_go requires 'from' and 'to', we need to know the current location
        # For this exploration, we assume the robot starts at the first location
        if len(location_names) < 2:
            print("[Exploration] Not enough locations to explore.")
        else:
            current_loc = location_names[0]
            for target_loc in location_names[1:]:
                print(f"[Exploration] Attempting to move robot from {current_loc} to {target_loc} using execute_go.")
                try:
                    obs, reward, done = execute_go(
                        env,
                        task,
                        from_location=current_loc,
                        to_location=target_loc,
                        max_steps=100,
                        threshold=0.01,
                        timeout=10.0
                    )
                    print(f"[Exploration] Robot moved to {target_loc}.")
                    # After moving, check if the robot is at 'floor'
                    if 'floor' in target_loc.lower():
                        print("[Exploration] Robot is now at 'floor'. Predicate (robot-at floor) is valid.")
                        # Exploration complete, break
                        break
                    current_loc = target_loc
                except Exception as e:
                    print(f"[Exploration] Failed to move to {target_loc}: {e}")

        # If 'execute_go' is not sufficient, try other skills (e.g., execute_pick, execute_place) as needed
        # For this exploration, we focus on location predicates

        print("[Exploration] Exploration phase complete. Check logs for missing predicate information.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
