# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at loc_a)
        # The missing predicate is likely related to the robot's location.
        # We will use available skills to explore and check which predicate is missing.

        # Since we do not have the actual oracle plan, we perform an exploration
        # using the available skills to determine which predicate is missing.

        # Available skills:
        # ['execute_pick', 'execute_place', 'execute_push', 'execute_pull', 'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper']

        # Let's try to use 'execute_go' to move the robot and see if the predicate (robot-at ...) is updated.

        # For demonstration, we assume there are at least two locations in the environment.
        # We'll try to move the robot from one location to another using 'execute_go'.

        # Extract location names from positions (if available)
        location_names = []
        for name, pos in positions.items():
            if 'loc' in name or 'room' in name or 'drawer' in name:
                location_names.append(name)
        # Fallback: if no location names found, use generic names
        if len(location_names) < 2:
            location_names = ['loc_a', 'loc_b']

        from_location = location_names[0]
        to_location = location_names[1]

        print(f"[Exploration] Attempting to move robot from {from_location} to {to_location} using execute_go.")

        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location,
                to_location
            )
            print(f"[Exploration] execute_go called: robot should now be at {to_location}.")
        except Exception as e:
            print(f"[Exploration] Error during execute_go: {e}")

        # After moving, check if the predicate (robot-at ...) is present in the observation or state
        # (Assume task.get_observation() returns a dict or similar structure)
        try:
            current_obs = task.get_observation()
            print(f"[Exploration] Current observation after execute_go: {current_obs}")
        except Exception as e:
            print(f"[Exploration] Error retrieving observation: {e}")

        # If the predicate (robot-at ...) is missing or not updated, this is the missing predicate.
        # Otherwise, continue with further exploration as needed.

        # === End of Exploration Phase ===

        # TODO: If further exploration is needed, repeat with other skills or locations.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
