# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We will use available skills to explore and confirm the robot's location predicates.

        # The available skills are:
        # ['execute_pick', 'execute_place', 'execute_push', 'execute_pull', 'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper']

        # We will attempt to use 'execute_go' to move the robot and observe the effect.
        # If the robot is already at 'floor', we can try to move to another location if available.

        # For demonstration, let's print all available positions and try to move the robot.
        print("[Exploration] Available object positions:", positions)

        # Try to find two different locations to use with execute_go
        location_names = []
        for name, pos in positions.items():
            if 'floor' in name or 'room' in name or 'location' in name:
                location_names.append(name)
        # Fallback: if no explicit location names, just use all keys
        if len(location_names) < 2:
            location_names = list(positions.keys())

        # If we have at least two locations, try to move between them
        if len(location_names) >= 2:
            from_location = location_names[0]
            to_location = location_names[1]
            print(f"[Exploration] Attempting to move robot from '{from_location}' to '{to_location}' using execute_go.")
            try:
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_location,
                    to_location
                )
                print(f"[Exploration] execute_go succeeded: Robot moved from '{from_location}' to '{to_location}'.")
            except Exception as e:
                print(f"[Exploration] execute_go failed: {e}")
        else:
            print("[Exploration] Not enough locations found to perform execute_go.")

        # After moving, try to use another skill to further explore predicates
        # For example, try execute_pick if there is an object on the floor
        object_on_floor = None
        for obj_name in positions.keys():
            if 'object' in obj_name or 'ball' in obj_name or 'handle' in obj_name:
                object_on_floor = obj_name
                break

        if object_on_floor and len(location_names) > 0:
            try:
                print(f"[Exploration] Attempting to pick '{object_on_floor}' at '{location_names[1]}' using execute_pick.")
                obs, reward, done = execute_pick(
                    env,
                    task,
                    object_on_floor,
                    location_names[1]
                )
                print(f"[Exploration] execute_pick succeeded: Picked '{object_on_floor}' at '{location_names[1]}'.")
            except Exception as e:
                print(f"[Exploration] execute_pick failed: {e}")
        else:
            print("[Exploration] No suitable object found to pick.")

        # The above exploration steps should help identify if the predicate (robot-at floor) is missing or misused.
        # You can add more exploration steps as needed, using only the available skills.

        print("[Exploration] Exploration phase complete. Check logs and feedback for missing predicates.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()