# run_skeleton_task.py (Completed for Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback: (robot-at floor)
        # The missing predicate is likely related to the robot's location, e.g., (robot-at floor)
        # We will use available skills to explore and confirm the robot's location predicates.

        # The available skills are:
        # ['execute_pick', 'execute_place', 'execute_push', 'execute_pull', 'execute_sweep', 'execute_rotate', 'execute_go', 'execute_gripper']

        # We will attempt to use 'execute_go' to move the robot and observe the effect.
        # If the robot is already at 'floor', we can try to move to another location if available.

        # For demonstration, let's print all available positions and try to move the robot.
        print("[Exploration] Available object positions:", positions)

        # Try to find two different locations to test execute_go
        location_names = []
        for name, pos in positions.items():
            if 'floor' in name or 'room' in name or 'drawer' in name or 'table' in name or 'loc' in name:
                location_names.append(name)
        # Remove duplicates and keep only unique location names
        location_names = list(set(location_names))

        # If we have at least two locations, try to move between them
        if len(location_names) >= 2:
            from_loc = location_names[0]
            to_loc = location_names[1]
            print(f"[Exploration] Attempting to move robot from '{from_loc}' to '{to_loc}' using execute_go.")
            try:
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_location=from_loc,
                    to_location=to_loc,
                    max_steps=100,
                    threshold=0.01,
                    timeout=10.0
                )
                print(f"[Exploration] Robot moved from '{from_loc}' to '{to_loc}'.")
            except Exception as e:
                print(f"[Exploration] Failed to execute_go from '{from_loc}' to '{to_loc}': {e}")
        else:
            print("[Exploration] Not enough locations found to perform execute_go.")

        # After moving, check if the robot's location predicate is updated
        # This helps us confirm the missing predicate (robot-at floor) is being used in the environment

        # === End of Exploration Phase ===

        # TODO: Continue with the main oracle plan after exploration, using only predefined skills.
        # For now, the focus is on exploration and predicate identification as per feedback.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()