from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """
    Opens one drawer by executing the necessary sequence:
    1. Turn on the light if the room is dark.
    2. Pick a handle of an unlocked, closed drawer.
    3. Pull the handle to open the drawer.
    """
    robot = RobotController()

    # Step 1: Turn on the light (execute_push_switch)
    try:
        robot.execute_movement(Object["light_switch"], mode=7, location="ready-pose")
    except Exception as error:
        print(f"Error during execute_push_switch on light_switch: {error}")

    # Step 2: Pick the handle of an unlocked, closed drawer (choose bottom drawer for example)
    try:
        robot.execute_movement(Object["handle_bottom"], mode=1, axis=0)
    except Exception as error:
        print(f"Error during execute_pick on handle_bottom: {error}")

    # Step 3: Pull the handle to open the drawer
    try:
        robot.execute_movement(Object["handle_bottom"], mode=4, distance=0.1)
    except Exception as error:
        print(f"Error during execute_pull on handle_bottom: {error}")

def main():
    """
    Main entry point to open one drawer.
    """
    open_one_drawer()

if __name__ == "__main__":
    main()