"""Module to slide one drawer open, ensuring all domain preconditions are satisfied."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Slides one drawer open, ensuring light is on and preconditions are met."""
    robot = RobotController()

    try:
        # Step 1: If the room is dark, turn on the light first
        if robot.get_room_light_state() == "dark":
            robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

        # Step 2: Move to the drawer area if not already there
        if robot.get_robot_location() != Object["drawer-area"]:
            robot.execute_go(Object["ready-pose"], Object["drawer-area"])

        # Step 3: Pick the handle of one drawer (choose bottom drawer for determinism)
        robot.execute_movement(Object["handle_bottom"], mode=1, axis=0)

        # Step 4: Pull the drawer open using the handle
        robot.execute_movement(Object["handle_bottom"], mode=4, axis=0, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()