from Object_list import Object
from skill_mapping import RobotController

def open_one_drawer():
    """
    Opens any one unlocked and closed drawer, ensuring all preconditions are met.
    """
    robot = RobotController()

    # Step 1: If the room is dark, turn on the light
    if robot.get_room_light_state() == "dark":
        robot.execute_movement(Object["light_switch"], mode=2, axis=1)

    # Step 2: Find any unlocked and closed drawer
    drawers = [
        ("drawer_bottom", "drawer_bottom_handle"),
        ("drawer_middle", "drawer_middle_handle"),
        ("drawer_top", "drawer_top_handle"),
    ]
    selected_drawer = None
    selected_handle = None
    for drawer, handle in drawers:
        if robot.get_drawer_lock_state(Object[drawer]) == "unlocked" and robot.get_drawer_open_state(Object[drawer]) == "closed":
            selected_drawer = drawer
            selected_handle = handle
            break

    if selected_drawer is None:
        print("No unlocked and closed drawer available to open.")
        return

    # Step 3: Pick the handle of the selected drawer
    robot.execute_movement(Object[selected_handle], mode=1, axis=0)

    # Step 4: Pull the drawer using the handle
    robot.execute_movement(Object[selected_handle], mode=4, axis=0, distance=0.1)

def main():
    """
    Main entry point to open one drawer.
    """
    open_one_drawer()

if __name__ == "__main__":
    main()