"""Module to pull open a single drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Pull open a single drawer."""
    robot = RobotController()

    try:
        # Step 1: Move to the light switch and turn on the light
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)
        robot.execute_push_switch(Object["light_switch"])

        # Step 2: Move to the handle of a drawer (e.g., bottom drawer)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pick the handle
        robot.execute_pick(Object["drawer_bottom_handle"])

        # Step 4: Pull to open the drawer using the handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()