from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Slide one drawer open: turn on the light, pick a handle, and pull to open a drawer."""
    robot = RobotController()

    try:
        # Step 1: If the room is dark, turn on the light
        robot.execute_movement(Object["light_switch"], mode=2, axis=1)
    except Exception as exc:
        print(f"Error during execute_push_switch on light_switch: {exc}")

    try:
        # Step 2: Pick the handle of a drawer (choose bottom drawer for determinism)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as exc:
        print(f"Error during execute_pick on drawer_bottom_handle: {exc}")

    try:
        # Step 3: Pull the drawer open using the handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as exc:
        print(f"Error during execute_pull on drawer_bottom_handle: {exc}")

def main():
    """Main entry point."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()