"""Module to open up one of the drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to open up one of the drawers (drawer_bottom) as an example."""
    robot = RobotController()

    try:
        # Step 1: Turn on the light if the room is dark (execute_push_switch)
        robot.execute_movement(Object["light_switch"], mode=2)

        # Step 2: Pick the handle of the drawer (execute_pick)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the drawer using the handle (execute_pull)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()