"""Module to slide one drawer open, following PDDL task requirements."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to slide one drawer open, ensuring all PDDL preconditions are met."""
    robot = RobotController()

    # Step 1: Ensure robot is at ready-pose; if not, move there
    if not robot.is_at_location("ready-pose"):
        robot.execute_go(current_location=robot.get_current_location(), target_location="ready-pose")

    # Step 2: If the room is dark, turn on the light
    if robot.is_room_dark():
        robot.execute_push_switch(Object["light_switch"], location="ready-pose")

    # Step 3: Ensure hand is empty and robot is free
    if not robot.is_hand_empty():
        robot.release_held_object()
    if not robot.is_robot_free():
        robot.set_robot_free()

    # Step 4: Ensure handle_bottom is on the floor at ready-pose
    if not robot.is_object_on_floor("handle_bottom"):
        robot.place_object_on_floor("handle_bottom", location="ready-pose")

    # Step 5: Pick up the handle_bottom at ready-pose
    robot.execute_pick(Object["handle_bottom"], location="ready-pose")

    # Step 6: Ensure drawer_bottom is unlocked and closed
    if not robot.is_drawer_unlocked("drawer_bottom"):
        robot.unlock_drawer("drawer_bottom")
    if not robot.is_drawer_closed("drawer_bottom"):
        robot.close_drawer("drawer_bottom")

    # Step 7: Pull the drawer_bottom using handle_bottom at ready-pose
    robot.execute_pull(drawer=Object["drawer_bottom"], handle=Object["handle_bottom"], location="ready-pose")

def main():
    """Main entry point to execute the drawer opening sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()