"""Module to open one of the drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to open one of the drawers (bottom drawer) with all required preconditions."""
    robot = RobotController()

    try:
        # Step 1: Move to the light switch location and turn on the light if the room is dark
        robot.execute_movement(Object["light_switch"], mode=1)
        robot.execute_push_switch(Object["light_switch"])

        # Step 2: Move to the bottom drawer handle and pick it
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        robot.execute_pick(Object["drawer_bottom_handle"])

        # Step 3: Pull the bottom drawer using the handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()