from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Uncover a drawer by opening it, following all domain preconditions.
    """
    robot = RobotController()

    try:
        # Step 1: Move to the light switch location if not already there
        if not robot.is_at_location(Object["light_switch_location"]):
            robot.execute_movement(Object["light_switch_location"], mode=0)
        # Step 2: If the room is dark, turn on the light
        if robot.is_room_dark():
            robot.execute_push_switch(Object["light_switch"])
        # Step 3: Move to the drawer area if not already there
        if not robot.is_at_location(Object["drawer-area"]):
            robot.execute_movement(Object["drawer-area"], mode=0)
        # Step 4: Ensure the drawer is unlocked
        if robot.is_drawer_locked(Object["drawer_bottom"]):
            raise Exception("Drawer is locked and cannot be opened.")
        # Step 5: Ensure the drawer is closed
        if not robot.is_drawer_closed(Object["drawer_bottom"]):
            raise Exception("Drawer must be closed before opening.")
        # Step 6: Pick up the correct handle (handle_bottom)
        if not robot.is_holding(Object["handle_bottom"]):
            if not robot.is_on_floor(Object["handle_bottom"]):
                raise Exception("Handle_bottom is not accessible for picking.")
            robot.execute_pick(Object["handle_bottom"])
        # Step 7: Pull the handle to open the drawer
        robot.execute_pull(Object["drawer_bottom"], Object["handle_bottom"])
        # Step 8: Release the handle after opening
        robot.execute_release(Object["handle_bottom"])
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """
    Main entry point for the drawer opening task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()