from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the handle_bottom (drawer_bottom_handle) from ready-pose
        # Mapping: handle_bottom → "drawer_bottom_handle" in Object list
        # approach axis: 0 = x-axis for handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 2: Pull to open the bottom drawer using handle_bottom at ready-pose
        # mode 4 = pull, axis is ignored, distance=0.1 for full open
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
