# ====== (Continuation after [Frozen Code End]) ======

    if done:
        print("[Task] Task ended after move to bottom_anchor_pos!")
        shutdown_environment(env)
        return

    # Step 4: Move to joint position of the bottom drawer (simulate grasping the handle)
    try:
        bottom_joint_pos = positions['bottom_joint_pos']
    except KeyError:
        print("[Error] 'bottom_joint_pos' not found in object positions.")
        shutdown_environment(env)
        return

    print("[Task] Moving to bottom drawer joint position:", bottom_joint_pos)
    obs, reward, done = move(
        env,
        task,
        target_pos=np.array(bottom_joint_pos),
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after move to bottom_joint_pos!")
        shutdown_environment(env)
        return

    # Step 5: Pull the drawer open (along x axis, positive direction)
    pull_distance = 0.15
    print("[Task] Pulling the bottom drawer open (along +x axis, 0.15m)")
    obs, reward, done = pull(
        env,
        task,
        pull_distance=pull_distance,
        pull_axis='x',
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after pull!")
        shutdown_environment(env)
        return

    # Step 6: Move to the rubbish (item3) on the table
    try:
        item3_pos = positions['item3']
    except KeyError:
        print("[Error] 'item3' (rubbish) not found in object positions.")
        shutdown_environment(env)
        return

    print("[Task] Moving to rubbish (item3) position:", item3_pos)
    obs, reward, done = move(
        env,
        task,
        target_pos=np.array(item3_pos),
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after move to item3!")
        shutdown_environment(env)
        return

    # Step 7: Pick the rubbish (item3)
    print("[Task] Picking up rubbish (item3)")
    obs, reward, done = pick(
        env,
        task,
        target_pos=np.array(item3_pos),
        approach_distance=0.15,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after pick!")
        shutdown_environment(env)
        return

    # Step 8: Move to the bin
    try:
        bin_pos = positions['bin']
    except KeyError:
        print("[Error] 'bin' not found in object positions.")
        shutdown_environment(env)
        return

    print("[Task] Moving to bin position:", bin_pos)
    obs, reward, done = move(
        env,
        task,
        target_pos=np.array(bin_pos),
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after move to bin!")
        shutdown_environment(env)
        return

    # Step 9: Place the rubbish in the bin
    print("[Task] Placing rubbish (item3) in the bin")
    obs, reward, done = place(
        env,
        task,
        target_pos=np.array(bin_pos),
        approach_distance=0.15,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task completed successfully! Reward:", reward)
    else:
        print("[Task] Task not completed yet (done=False).")

    shutdown_environment(env)
    print("===== End of Skeleton Task =====")