obs, reward, done = rotate(env, task, target_quat)
    # [Step 2] Move to side position of bottom drawer
    try:
        positions = get_object_positions()
        side_pos = positions.get('bottom_side_pos')
        if side_pos is None:
            raise KeyError("bottom_side_pos not found in positions.")
        obs, reward, done = move(env, task, target_pos=np.array(side_pos))
        if done:
            print("[Task] Task ended after move to side position!")
            return
    except Exception as e:
        print(f"[Task] Exception during move to side position: {e}")
        return

    # [Step 3] Move to anchor position of bottom drawer
    try:
        anchor_pos = positions.get('bottom_anchor_pos')
        if anchor_pos is None:
            raise KeyError("bottom_anchor_pos not found in positions.")
        obs, reward, done = move(env, task, target_pos=np.array(anchor_pos))
        if done:
            print("[Task] Task ended after move to anchor position!")
            return
    except Exception as e:
        print(f"[Task] Exception during move to anchor position: {e}")
        return

    # [Step 4] Pick the drawer handle (simulate as pick at anchor position)
    try:
        obs, reward, done = pick(env, task, target_pos=np.array(anchor_pos), approach_distance=0.10, approach_axis='z')
        if done:
            print("[Task] Task ended after pick drawer handle!")
            return
    except Exception as e:
        print(f"[Task] Exception during pick drawer handle: {e}")
        return

    # [Step 5] Pull the drawer open
    try:
        obs, reward, done = pull(env, task, pull_distance=0.15, pull_axis='x')
        if done:
            print("[Task] Task ended after pull!")
            return
    except Exception as e:
        print(f"[Task] Exception during pull: {e}")
        return

    # [Step 6] Pick up the rubbish from the table
    try:
        rubbish_pos = positions.get('rubbish')
        if rubbish_pos is None:
            raise KeyError("rubbish not found in positions.")
        obs, reward, done = pick(env, task, target_pos=np.array(rubbish_pos), approach_distance=0.15, approach_axis='z')
        if done:
            print("[Task] Task ended after pick rubbish!")
            return
    except Exception as e:
        print(f"[Task] Exception during pick rubbish: {e}")
        return

    # [Step 7] Place the rubbish into the bin
    try:
        bin_pos = positions.get('bin')
        if bin_pos is None:
            raise KeyError("bin not found in positions.")
        obs, reward, done = place(env, task, target_pos=np.array(bin_pos), approach_distance=0.15, approach_axis='z')
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")
    except Exception as e:
        print(f"[Task] Exception during place rubbish: {e}")
        return