# (Continue after [Frozen Code End])

try:
    # Step 5: Pull the drawer open (pull along x axis, positive direction)
    # We'll use a reasonable pull distance (e.g., 0.15m)
    obs, reward, done = pull(
        env,
        task,
        pull_distance=0.15,
        pull_axis='x',
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after pull!")
        return
except Exception as e:
    print(f"[Task] Exception during pull: {e}")
    shutdown_environment(env)
    return

try:
    # Step 6: Pick the rubbish from the table (assume it's at its position)
    obs, reward, done = pick(
        env,
        task,
        target_pos=positions['rubbish'],
        approach_distance=0.15,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after pick rubbish!")
        return
except Exception as e:
    print(f"[Task] Exception during pick rubbish: {e}")
    shutdown_environment(env)
    return

try:
    # Step 7: Place the rubbish into the bin
    obs, reward, done = place(
        env,
        task,
        target_pos=positions['bin'],
        approach_distance=0.15,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task completed successfully! Reward:", reward)
    else:
        print("[Task] Task not completed yet (done=False).")
except Exception as e:
    print(f"[Task] Exception during place rubbish: {e}")
    shutdown_environment(env)
    return