def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer = 'bottom'
        robot_position = 'initial_position'
        target_position = 'target_position'

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer.")
        move(env, robot_position, drawer)

        # Step 2: Check if the drawer is locked
        if not obs['is-locked']:
            # Step 3: Open the drawer
            print("[Task] Opening the drawer.")
            pull(env, drawer)

        # Step 4: Pick the object from the drawer
        print("[Task] Picking the object from the drawer.")
        pick(env, 'object', drawer)

        # Step 5: Move to the target position
        print("[Task] Moving to the target position.")
        move(env, drawer, target_position)

        # Step 6: Place the object at the target position
        print("[Task] Placing the object at the target position.")
        place(env, 'object', target_position)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()