obs, reward, done = rotate(env, task, target_quat)
# === Step 2: Move to side position of bottom drawer ===
try:
    positions = get_object_positions()
    side_pos = positions.get('bottom_side_pos', None)
    if side_pos is None:
        raise KeyError("bottom_side_pos not found in positions.")
    obs, reward, done = move(env, task, side_pos)
    if done:
        print("[Task] Task ended after move to side position!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Move to side position failed: {e}")
    shutdown_environment(env)
    return

# === Step 3: Move to anchor position of bottom drawer ===
try:
    anchor_pos = positions.get('bottom_anchor_pos', None)
    if anchor_pos is None:
        raise KeyError("bottom_anchor_pos not found in positions.")
    obs, reward, done = move(env, task, anchor_pos)
    if done:
        print("[Task] Task ended after move to anchor position!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Move to anchor position failed: {e}")
    shutdown_environment(env)
    return

# === Step 4: Pick the drawer handle (simulate pick at anchor position) ===
try:
    obs, reward, done = pick(env, task, anchor_pos, approach_distance=0.10, approach_axis='z')
    if done:
        print("[Task] Task ended after picking drawer handle!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Pick drawer handle failed: {e}")
    shutdown_environment(env)
    return

# === Step 5: Pull the drawer open ===
try:
    pull_distance = 0.15  # Adjust as needed for your environment
    obs, reward, done = pull(env, task, pull_distance, pull_axis='x')
    if done:
        print("[Task] Task ended after pulling drawer!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Pull drawer failed: {e}")
    shutdown_environment(env)
    return

# === Step 6: Pick up tomato1 from table ===
try:
    tomato1_pos = positions.get('tomato1', None)
    if tomato1_pos is None:
        raise KeyError("tomato1 not found in positions.")
    obs, reward, done = pick(env, task, tomato1_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after picking tomato1!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Pick tomato1 failed: {e}")
    shutdown_environment(env)
    return

# === Step 7: Place tomato1 on plate ===
try:
    plate_pos = positions.get('plate', None)
    if plate_pos is None:
        raise KeyError("plate not found in positions.")
    obs, reward, done = place(env, task, plate_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after placing tomato1!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Place tomato1 failed: {e}")
    shutdown_environment(env)
    return

# === Step 8: Pick up tomato2 from table ===
try:
    tomato2_pos = positions.get('tomato2', None)
    if tomato2_pos is None:
        raise KeyError("tomato2 not found in positions.")
    obs, reward, done = pick(env, task, tomato2_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task ended after picking tomato2!")
        shutdown_environment(env)
        return
except Exception as e:
    print(f"[ERROR] Pick tomato2 failed: {e}")
    shutdown_environment(env)
    return

# === Step 9: Place tomato2 on plate ===
try:
    obs, reward, done = place(env, task, plate_pos, approach_distance=0.15, approach_axis='z')
    if done:
        print("[Task] Task completed successfully! Reward:", reward)
    else:
        print("[Task] Task not completed yet (done=False).")
except Exception as e:
    print(f"[ERROR] Place tomato2 failed: {e}")
    shutdown_environment(env)
    return