try:
    # --- Step 7: Place item1 onto plate ---
    try:
        plate_pos = positions['plate']
    except KeyError:
        print("[Error] 'plate' position not found in object_positions.")
        shutdown_environment(env)
        return

    print("[Task] Placing item1 onto plate at:", plate_pos)
    try:
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
    except Exception as e:
        print("[Error] Exception during place (item1):", e)
        shutdown_environment(env)
        return
    if done:
        print("[Task] Task ended after placing item1!")
        return

    # --- Step 8: Pick up item2 (tomato2) from table ---
    try:
        item2_pos = positions['item2']
    except KeyError:
        print("[Error] 'item2' position not found in object_positions.")
        shutdown_environment(env)
        return

    print("[Task] Picking up item2 at:", item2_pos)
    try:
        obs, reward, done = pick(
            env,
            task,
            target_pos=item2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
    except Exception as e:
        print("[Error] Exception during pick (item2):", e)
        shutdown_environment(env)
        return
    if done:
        print("[Task] Task ended after picking item2!")
        return

    # --- Step 9: Place item2 onto plate ---
    print("[Task] Placing item2 onto plate at:", plate_pos)
    try:
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
    except Exception as e:
        print("[Error] Exception during place (item2):", e)
        shutdown_environment(env)
        return
    if done:
        print("[Task] Task ended after placing item2!")
        return

    print("[Task] Task completed successfully! Reward:", reward)

except Exception as e:
    print("[Error] Unexpected exception during task execution:", e)
    shutdown_environment(env)
    return