# === Complete the code after the frozen region ===

# The following code assumes the context of the skeleton and continues the plan
# to achieve: open a drawer, pick up all tomatoes (item1, item2), and place them on the plate.

try:
    # Step 8: Move above item1 (again, for plan compliance)
    print("[Step 8] Move above item1 (again)")
    obs, reward, done = move(
        env,
        task,
        target_pos=positions['item1'] + np.array([0, 0, 0.10]),
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after move above item1 (again)!")
        shutdown_environment(env)
        exit()

    # Step 9: Pick item1
    print("[Step 9] Pick item1")
    obs, reward, done = pick(
        env,
        task,
        target_pos=positions['item1'],
        approach_distance=0.10,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after pick item1!")
        shutdown_environment(env)
        exit()

    # Step 10: Place item1 on plate
    print("[Step 10] Place item1 on plate")
    obs, reward, done = place(
        env,
        task,
        target_pos=positions['plate'],
        approach_distance=0.10,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after place item1!")
        shutdown_environment(env)
        exit()

    # Step 11: Move above item2
    print("[Step 11] Move above item2")
    obs, reward, done = move(
        env,
        task,
        target_pos=positions['item2'] + np.array([0, 0, 0.10]),
        max_steps=100,
        threshold=0.01,
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after move above item2!")
        shutdown_environment(env)
        exit()

    # Step 12: Pick item2
    print("[Step 12] Pick item2")
    obs, reward, done = pick(
        env,
        task,
        target_pos=positions['item2'],
        approach_distance=0.10,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after pick item2!")
        shutdown_environment(env)
        exit()

    # Step 13: Place item2 on plate
    print("[Step 13] Place item2 on plate")
    obs, reward, done = place(
        env,
        task,
        target_pos=positions['plate'],
        approach_distance=0.10,
        max_steps=100,
        threshold=0.01,
        approach_axis='z',
        timeout=10.0
    )
    if done:
        print("[Task] Task ended after place item2!")
        shutdown_environment(env)
        exit()

    print("[Task] Task completed successfully! Reward:", reward)

except Exception as e:
    print("[Task] Exception occurred:", str(e))
    shutdown_environment(env)