# (This is the code to be appended after the [Frozen Code End] region, following the skeleton and plan.)

# Step 6: Move gripper to a safe waypoint (e.g., above drawer)
print("[Step 6] Move gripper to a safe waypoint (e.g., above drawer)")
try:
    if 'waypoint1' in positions:
        safe_pos = positions['waypoint1']
    else:
        safe_pos = np.array(obs.gripper_pose[:3]) + np.array([0, 0, 0.10])
except Exception as e:
    print(f"[Warning] Could not determine safe waypoint: {e}")
    safe_pos = np.array(obs.gripper_pose[:3]) + np.array([0, 0, 0.10])
obs, reward, done = move(
    env, task,
    target_pos=safe_pos
)
if done:
    print("[Task] Task ended after step 6!")
    return

# Step 7: Rotate gripper back to 0 degrees (for object manipulation)
print("[Step 7] Rotate gripper to 0 degrees")
try:
    if 'zero_deg' in positions:
        target_quat_0 = positions['zero_deg']
        # If it's a scalar, synthesize quaternion
        if isinstance(target_quat_0, (float, int)):
            from scipy.spatial.transform import Rotation as R
            target_quat_0 = R.from_euler('z', 0, degrees=True).as_quat()
    else:
        from scipy.spatial.transform import Rotation as R
        target_quat_0 = R.from_euler('z', 0, degrees=True).as_quat()
except Exception as e:
    print(f"[Warning] Could not determine zero_deg quaternion: {e}")
    from scipy.spatial.transform import Rotation as R
    target_quat_0 = R.from_euler('z', 0, degrees=True).as_quat()
obs, reward, done = rotate(
    env, task,
    target_quat=target_quat_0
)
if done:
    print("[Task] Task ended after step 7!")
    return

# Step 8: Move above item1 (tomato1)
print("[Step 8] Move above item1 (tomato1)")
try:
    item1_pos = positions['item1']
    above_item1 = np.array(item1_pos) + np.array([0, 0, 0.10])
except Exception as e:
    print(f"[Error] Could not get item1 position: {e}")
    return
obs, reward, done = move(
    env, task,
    target_pos=above_item1
)
if done:
    print("[Task] Task ended after step 8!")
    return

# Step 9: Pick up item1 (tomato1)
print("[Step 9] Pick up item1 (tomato1)")
obs, reward, done = pick(
    env, task,
    target_pos=item1_pos,
    approach_distance=0.10,
    approach_axis='z'
)
if done:
    print("[Task] Task ended after step 9!")
    return

# Step 10: Place item1 on plate
print("[Step 10] Place item1 on plate")
try:
    plate_pos = positions['plate']
    above_plate = np.array(plate_pos) + np.array([0, 0, 0.10])
except Exception as e:
    print(f"[Error] Could not get plate position: {e}")
    return
obs, reward, done = move(
    env, task,
    target_pos=above_plate
)
if done:
    print("[Task] Task ended after step 10 (move above plate)!")
    return
obs, reward, done = place(
    env, task,
    target_pos=plate_pos,
    approach_distance=0.10,
    approach_axis='z'
)
if done:
    print("[Task] Task ended after step 10 (place)!")
    return

# Step 11: Move above item2 (tomato2)
print("[Step 11] Move above item2 (tomato2)")
try:
    item2_pos = positions['item2']
    above_item2 = np.array(item2_pos) + np.array([0, 0, 0.10])
except Exception as e:
    print(f"[Error] Could not get item2 position: {e}")
    return
obs, reward, done = move(
    env, task,
    target_pos=above_item2
)
if done:
    print("[Task] Task ended after step 11!")
    return

# Step 12: Pick up item2 (tomato2)
print("[Step 12] Pick up item2 (tomato2)")
obs, reward, done = pick(
    env, task,
    target_pos=item2_pos,
    approach_distance=0.10,
    approach_axis='z'
)
if done:
    print("[Task] Task ended after step 12!")
    return

# Step 13: Place item2 on plate
print("[Step 13] Place item2 on plate")
obs, reward, done = move(
    env, task,
    target_pos=above_plate
)
if done:
    print("[Task] Task ended after step 13 (move above plate)!")
    return
obs, reward, done = place(
    env, task,
    target_pos=plate_pos,
    approach_distance=0.10,
    approach_axis='z'
)
if done:
    print("[Task] Task ended after step 13 (place)!")
    return

print("[Task] Task completed successfully! Reward:", reward)