def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        gripper = 'gripper'
        drawer = 'drawer'
        bottom_position = 'bottom'
        side_position = 'side'
        anchor_position = 'anchor'

        # Step 1: Move to the drawer's side position
        print("[Task] Moving to the side position of the drawer.")
        move(env, gripper, side_position, bottom_position)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick(env, drawer, bottom_position, gripper)

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        pull(env, gripper, drawer)

        # Step 4: Place the drawer back
        print("[Task] Placing the drawer back.")
        place(env, drawer, bottom_position)

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()