def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        bottom_side_pos = positions['bottom_side_pos']  # Replace with actual position key

        # Step 1: Move to the bottom side position
        print("[Task] Moving to bottom side position.")
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to bottom side position!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, bottom_side_pos, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Place the drawer back (if needed)
        print("[Task] Placing the drawer back.")
        obs, reward, done = place(env, drawer, bottom_side_pos)
        if done:
            print("[Task] Task ended after placing the drawer back!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()