[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Expected keys in positions:
        #  'middle_side_pos', 'middle_anchor_pos', 'middle_joint_pos', 'rubbish', 'bin'

        # === Oracle Plan Execution ===
        print("[Task] Executing Oracle Plan")
        side_middle_pos = positions['middle_side_pos']
        anchor_middle_pos = positions['middle_anchor_pos']
        joint_middle_pos = positions['middle_joint_pos']
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        try:
            # Step 1: rotate gripper from zero to ninety degrees
            print("[Task] Step 1: rotate gripper to 90 degrees")
            # build quaternion for 90° about z-axis
            ninety_deg_quat = R.from_euler('xyz', [0, 0, 90], degrees=True).as_quat()
            obs, reward, done = rotate(env, task, ninety_deg_quat)
            if done:
                print("[Task] Done early after rotate.")
                return

            # Step 2: move to side position of middle drawer
            print("[Task] Step 2: move to side position of middle drawer")
            obs, reward, done = move(env, task, np.array(side_middle_pos))
            if done:
                print("[Task] Done early after move-to-side.")
                return

            # Step 3: move to anchor position of middle drawer
            print("[Task] Step 3: move to anchor position of middle drawer")
            obs, reward, done = move(env, task, np.array(anchor_middle_pos))
            if done:
                print("[Task] Done early after move-to-anchor.")
                return

            # Step 4: pick the drawer handle (joint)
            print("[Task] Step 4: pick drawer handle")
            obs, reward, done = pick(env, task, np.array(joint_middle_pos))
            if done:
                print("[Task] Done early after pick-drawer.")
                return

            # Step 5: pull the drawer open
            print("[Task] Step 5: pull drawer open")
            # estimate a reasonable pull distance (meters)
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
            if done:
                print("[Task] Done early after pull.")
                return

            # Step 6: pick up the rubbish on the table
            print("[Task] Step 6: pick rubbish")
            obs, reward, done = pick(env, task, np.array(rubbish_pos))
            if done:
                print("[Task] Done early after picking rubbish.")
                return

            # Step 7: place rubbish into the bin
            print("[Task] Step 7: place rubbish into bin")
            obs, reward, done = place(env, task, np.array(bin_pos))
            if done:
                print("[Task] Task completed successfully! Reward:", reward)
            else:
                print("[Task] Plan executed but done flag is False. Reward:", reward)

        except Exception as e:
            print(f"[Task] Exception during plan execution: {e}")
            raise

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()