[Frozen Code Start]
    
[Frozen Code End]

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Plan Execution ===

        # Step 1: Rotate to current orientation (no-op but fulfills plan requirement)
        initial_quat = normalize_quaternion(obs.gripper_pose[3:7])
        print("[Task] Step 1: Rotate to initial orientation")
        obs, reward, done = rotate(env, task, target_quat=initial_quat)
        if done:
            print("[Task] Terminated after step 1.")
            return

        # Step 2: Move to bottom anchor position
        if 'bottom_anchor_pos' not in positions:
            raise KeyError("Position key 'bottom_anchor_pos' not found in positions.")
        bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])
        print(f"[Task] Step 2: Move to bottom anchor pos: {bottom_anchor_pos}")
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Terminated after step 2.")
            return

        # Step 3: Pick the bottom drawer handle
        if 'bottom_joint_pos' not in positions:
            raise KeyError("Position key 'bottom_joint_pos' not found in positions.")
        bottom_joint_pos = np.array(positions['bottom_joint_pos'])
        print(f"[Task] Step 3: Pick bottom drawer handle at: {bottom_joint_pos}")
        obs, reward, done = pick(env, task, target_pos=bottom_joint_pos)
        if done:
            print("[Task] Terminated after step 3.")
            return

        # Step 4: Pull the drawer open
        pull_distance = 0.1  # meters, adjust if needed
        pull_axis = 'x'
        print(f"[Task] Step 4: Pull drawer (distance={pull_distance}, axis={pull_axis})")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
        if done:
            print("[Task] Terminated after step 4.")
            return

        # Step 5: Pick up the rubbish
        if 'rubbish' not in positions:
            raise KeyError("Position key 'rubbish' not found in positions.")
        rubbish_pos = np.array(positions['rubbish'])
        print(f"[Task] Step 5: Pick rubbish at: {rubbish_pos}")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Terminated after step 5.")
            return

        # Step 6: Place the rubbish into the bin
        if 'bin' not in positions:
            raise KeyError("Position key 'bin' not found in positions.")
        bin_pos = np.array(positions['bin'])
        print(f"[Task] Step 6: Place rubbish at bin: {bin_pos}")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Completed all steps successfully. Reward:", reward)
        else:
            print(f"[Task] Plan execution ended. done={done}, reward={reward}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()