from run_skeleton_task import run_skeleton_task  # assume this script is named run_skeleton_task.py
# No changes to imports or frozen region

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===
        try:
            # Step 1: rotate gripper from zero_deg to ninety_deg around z-axis
            print("[Plan] Step 1: rotate to 90 degrees about Z")
            q_z90 = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
            obs, reward, done = rotate(env, task, q_z90)
            if done:
                print("[Plan] Task ended after rotate.")
                return

            # Step 2: move-to-side (approach drawer side)
            print("[Plan] Step 2: move to side position of bottom drawer")
            target_side = positions['bottom_side_pos']
            obs, reward, done = move(env, task, target_side)
            if done:
                print("[Plan] Task ended after move-to-side.")
                return

            # Step 3: move-to-anchor (approach drawer handle)
            print("[Plan] Step 3: move to anchor position of bottom drawer")
            target_anchor = positions['bottom_anchor_pos']
            obs, reward, done = move(env, task, target_anchor)
            if done:
                print("[Plan] Task ended after move-to-anchor.")
                return

            # Step 4: pick-drawer (grasp the drawer handle)
            print("[Plan] Step 4: pick drawer handle")
            obs, reward, done = pick(env, task, target_anchor)
            if done:
                print("[Plan] Task ended after pick-drawer.")
                return

            # Step 5: pull (open the drawer)
            print("[Plan] Step 5: pull drawer open")
            pull_distance = 0.1  # meters; adjust if necessary
            obs, reward, done = pull(env, task, pull_distance)
            if done:
                print("[Plan] Task ended after pull.")
                return

            # Step 6: pick rubbish on table
            print("[Plan] Step 6: pick rubbish from table")
            target_rubbish = positions['rubbish']
            obs, reward, done = pick(env, task, target_rubbish)
            if done:
                print("[Plan] Task ended after picking rubbish.")
                return

            # Step 7: place rubbish into bin
            print("[Plan] Step 7: place rubbish into bin")
            target_bin = positions['bin']
            obs, reward, done = place(env, task, target_bin)
            if done:
                print("[Plan] Task ended after placing rubbish.")
                return

            # Final check
            print("[Plan] Oracle plan executed. Final reward:", reward)
        except Exception as e:
            print("[Error] Exception during plan execution:", e)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()