# Define key object positions
drawer_anchor_pos = positions['bottom_anchor_pos']
rubbish_pos        = positions['item1']
bin_pos            = positions['bin']

# Step 4: Pick the drawer handle
print("[Step 4] Picking drawer handle at:", drawer_anchor_pos)
obs, reward, done = pick(
    env, task,
    target_pos=drawer_anchor_pos,
    approach_distance=0.15,
    max_steps=100,
    threshold=0.01,
    approach_axis='z',
    timeout=10.0
)
if done:
    print("Task ended prematurely after Step 4.")
    return

# Step 5: Pull the drawer open
print("[Step 5] Pulling drawer open")
obs, reward, done = pull(
    env, task,
    pull_distance=0.1,
    pull_axis='x',
    max_steps=100,
    threshold=0.01,
    timeout=10.0
)
if done:
    print("Task ended prematurely after Step 5.")
    return

# Step 6: Move to the rubbish
print("[Step 6] Moving to rubbish at:", rubbish_pos)
obs, reward, done = move(
    env, task,
    target_pos=rubbish_pos,
    max_steps=100,
    threshold=0.01,
    timeout=10.0
)
if done:
    print("Task ended prematurely after Step 6.")
    return

# Step 7: Pick up the rubbish
print("[Step 7] Picking up rubbish at:", rubbish_pos)
obs, reward, done = pick(
    env, task,
    target_pos=rubbish_pos,
    approach_distance=0.15,
    max_steps=100,
    threshold=0.01,
    approach_axis='z',
    timeout=10.0
)
if done:
    print("Task ended prematurely after Step 7.")
    return

# Step 8: Move to the bin
print("[Step 8] Moving to bin at:", bin_pos)
obs, reward, done = move(
    env, task,
    target_pos=bin_pos,
    max_steps=100,
    threshold=0.01,
    timeout=10.0
)
if done:
    print("Task ended prematurely after Step 8.")
    return

# Step 9: Place the rubbish in the bin
print("[Step 9] Placing rubbish in bin at:", bin_pos)
obs, reward, done = place(
    env, task,
    target_pos=bin_pos,
    approach_distance=0.15,
    max_steps=100,
    threshold=0.01,
    approach_axis='z',
    timeout=10.0
)
if done:
    print("Task completed at Step 9 with done=True. Reward:", reward)
else:
    print("Task completed all steps. Final reward:", reward)