import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        positions = get_object_positions()
        side_pos = np.array(positions['bottom_side_pos'])
        anchor_pos = np.array(positions['bottom_anchor_pos'])
        if 'rubbish' in positions:
            rubbish_pos = np.array(positions['rubbish'])
        else:
            rubbish_pos = np.array(positions.get('item3'))
        bin_pos = np.array(positions['bin'])

        # Prepare current orientation for rotation
        obs0 = task.get_observation()
        current_quat = normalize_quaternion(obs0.gripper_pose[3:7])

        # === Oracle Plan Execution ===
        # Step 1–4: open drawer
        obs, reward, done = rotate(env, task, current_quat)
        obs, reward, done = move(env, task, side_pos)
        obs, reward, done = move(env, task, anchor_pos)
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')

        # Step 5: pick up rubbish
        print("[Task] Step 5: Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("[Task] Task ended after pick. Reward:", reward)
            return

        # Step 6: place rubbish in bin
        print("[Task] Step 6: Placing rubbish in bin at:", bin_pos)
        obs, reward, done = place(env, task, bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed (done=False). Reward:", reward)

    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()