    
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset environment and start video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()

        # Compute quaternions for 0° and 90° around Z
        zero_quat = R.from_euler('z', 0, degrees=True).as_quat()
        ninety_quat = R.from_euler('z', 90, degrees=True).as_quat()

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: rotate gripper zero_deg -> ninety_deg")
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        if done:
            print("[Plan] Terminated after rotate.")
            return

        # Step 2: Move to side position of bottom drawer
        print("[Plan] Step 2: move-to-side bottom drawer")
        side_pos = np.array(positions['bottom_side_pos'])
        obs, reward, done = move(env, task, target_pos=side_pos)
        if done:
            print("[Plan] Terminated after move-to-side.")
            return

        # Step 3: Move to anchor position of bottom drawer
        print("[Plan] Step 3: move-to-anchor bottom drawer")
        anchor_pos = np.array(positions['bottom_anchor_pos'])
        obs, reward, done = move(env, task, target_pos=anchor_pos)
        if done:
            print("[Plan] Terminated after move-to-anchor.")
            return

        # Step 4: Pick the drawer handle (grasp)
        print("[Plan] Step 4: pick-drawer at anchor position")
        obs, reward, done = pick(env, task, target_pos=anchor_pos)
        if done:
            print("[Plan] Terminated after pick-drawer.")
            return

        # Step 5: Pull open the drawer
        print("[Plan] Step 5: pull drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Terminated after pull.")
            return

        # Step 6: Pick the rubbish from its location
        print("[Plan] Step 6: pick rubbish from table")
        rubbish_pos = np.array(positions['rubbish'])
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Plan] Terminated after picking rubbish.")
            return

        # Step 7: Place the rubbish into the bin
        print("[Plan] Step 7: place rubbish into bin")
        bin_pos = np.array(positions['bin'])
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Completed successfully with reward:", reward)
        else:
            print("[Task] Not completed (done=False). Final reward:", reward)

    except Exception as e:
        print(f"[Error] Exception during plan execution: {e}")

    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()