        if done:
            print("[Task] Ended after rotate. Reward:", reward)
            return

        # Step 2: move to side position of bottom drawer
        print(f"[Task] Step 2: move to bottom side position {bottom_side}")
        obs, reward, done = move(env, task, target_pos=bottom_side)
        if done:
            print("[Task] Ended after move-to-side. Reward:", reward)
            return

        # Step 3: move to anchor position of bottom drawer
        print(f"[Task] Step 3: move to bottom anchor position {bottom_anchor}")
        obs, reward, done = move(env, task, target_pos=bottom_anchor)
        if done:
            print("[Task] Ended after move-to-anchor. Reward:", reward)
            return

        # Step 4: pick the drawer handle (anchor) to grasp the drawer
        print(f"[Task] Step 4: pick drawer at {bottom_anchor}")
        obs, reward, done = pick(env, task, target_pos=bottom_anchor)
        if done:
            print("[Task] Ended after pick-drawer. Reward:", reward)
            return

        # Step 5: pull the drawer open
        pull_distance = 0.10  # meters
        print(f"[Task] Step 5: pull drawer by {pull_distance} along x-axis")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Task] Ended after pull. Reward:", reward)
            return

        # Step 6: pick up the rubbish from the table
        print(f"[Task] Step 6: pick rubbish at {rubbish_pos}")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Ended after pick rubbish. Reward:", reward)
            return

        # Step 7: place the rubbish into the bin
        print(f"[Task] Step 7: place rubbish into bin at {bin_pos}")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Completed placing rubbish. Final reward:", reward)
        else:
            print("[Task] Plan executed. Done flag is False. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
        raise
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")