import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import move, pick, place, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # reset the task
        descriptions, obs = task.reset()
        # initialize video recording
        init_video_writers(obs)
        # wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # retrieve object positions
        positions = get_object_positions()
        # find a drawer handle position
        drawer_handle_key = None
        for key in positions:
            if "drawer_handle" in key or "drawer" in key:
                drawer_handle_key = key
                break
        if drawer_handle_key is None:
            print("[Task] No drawer handle found, aborting.")
            return
        drawer_handle_pos = positions[drawer_handle_key]

        # 1) Pull open the drawer (if unlocked)
        print(f"[Task] Pulling open drawer '{drawer_handle_key}' at {drawer_handle_pos}")
        try:
            obs, reward, done = pull(
                env,
                task,
                target_pos=drawer_handle_pos,
                approach_distance=0.05,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pull failed: {e}")
            return
        if done:
            print("[Task] Task ended during pull.")
            return

        # 2) Pick up the rubbish
        rubbish_key = None
        for key in positions:
            if "rubbish" in key or "trash" in key or "garbage" in key:
                rubbish_key = key
                break
        if rubbish_key is None:
            print("[Task] No rubbish found, aborting.")
            return
        rubbish_pos = positions[rubbish_key]
        print(f"[Task] Picking up '{rubbish_key}' at {rubbish_pos}")
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=rubbish_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pick failed: {e}")
            return
        if done:
            print("[Task] Task ended during pick.")
            return

        # 3) Place the rubbish into the bin
        bin_key = None
        for key in positions:
            if "bin" in key or "trash_bin" in key:
                bin_key = key
                break
        if bin_key is None:
            print("[Task] No bin found, aborting.")
            return
        bin_pos = positions[bin_key]
        print(f"[Task] Placing '{rubbish_key}' into '{bin_key}' at {bin_pos}")
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=bin_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] place failed: {e}")
            return
        if done:
            print("[Task] Task ended during place.")
            return

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()