import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import pick, place, move, rotate, pull
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers (optional)
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Replace these keys with the actual object names in your environment
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']

        # === Oracle Plan Execution ===

        # 1) Pick up object_1
        try:
            print(f"[Task] Picking object_1 at: {object_1_pos}")
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Task] Error during pick: {e}")
            return
        if done:
            print("[Task] Task ended after pick!")
            return

        # 2) Place object_1 at object_2_pos
        try:
            print(f"[Task] Placing object_1 at: {object_2_pos}")
            obs, reward, done = place(
                env,
                task,
                target_pos=object_2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Task] Error during place: {e}")
            return
        if done:
            print("[Task] Task ended after place!")
            return

        # 3) (Optional) Verify final state or perform any cleanup actions here
        print("[Task] Oracle plan executed successfully.")

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()