[Frozen Code Start]

[Frozen Code End]

    def run_skeleton_task():
        '''Generic skeleton for running any task in your simulation.'''
        print("===== Starting Skeleton Task =====")
        
        # === Environment Setup ===
        env, task = setup_environment()
        try:
            # Reset the task to its initial state
            descriptions, obs = task.reset()

            # (Optional) Initialize video writers for capturing your simulation
            init_video_writers(obs)

            # Wrap the task steps for recording (if needed)
            original_step = task.step
            task.step = recording_step(original_step)
            original_get_obs = task.get_observation
            task.get_observation = recording_get_observation(original_get_obs)

            # === Retrieve Object Positions ===
            positions = get_object_positions()
            # Expect positions to contain keys like
            # 'zero_deg', 'ninety_deg', 'bottom_side_pos', 'bottom_anchor_pos',
            # 'table', 'plate', 'tomato1', 'tomato2'
            
            # === Oracle Plan Execution ===
            # Step 1: Rotate from zero_deg to ninety_deg
            print("[Step 1] Rotating gripper to ninety_deg")
            target_quat = positions['ninety_deg']
            obs, reward, done = rotate(env, task, target_quat)
            if done:
                print("Early termination after rotate. Reward:", reward)
                return

            # Step 2: Move to drawer side position
            print("[Step 2] Moving gripper to side position of bottom drawer")
            side_pos = positions.get('bottom_side_pos', positions.get('side-pos-bottom'))
            obs, reward, done = move(env, task, target_pos=side_pos)
            if done:
                print("Early termination after move-to-side. Reward:", reward)
                return

            # Step 3: Move to drawer anchor position
            print("[Step 3] Moving gripper to anchor position of bottom drawer")
            anchor_pos = positions.get('bottom_anchor_pos', positions.get('anchor-pos-bottom'))
            obs, reward, done = move(env, task, target_pos=anchor_pos)
            if done:
                print("Early termination after move-to-anchor. Reward:", reward)
                return

            # Step 4: Pick the drawer handle (pick-drawer)
            print("[Step 4] Picking drawer handle")
            # Assume pick_drawer is imported from skill_code
            obs, reward, done = pick_drawer(env, task, target_pos=anchor_pos)
            if done:
                print("Early termination after pick-drawer. Reward:", reward)
                return

            # Step 5: Pull to open drawer
            print("[Step 5] Pulling drawer open")
            # Choose a small pull distance (e.g., 0.1 m)
            pull_distance = 0.1
            obs, reward, done = pull(env, task, pull_distance)
            if done:
                print("Early termination after pull. Reward:", reward)
                return

            # Step 6: Pick up tomato1 from table
            print("[Step 6] Picking up tomato1")
            tomato1_pos = positions['tomato1']
            obs, reward, done = pick(env, task, target_pos=tomato1_pos)
            if done:
                print("Early termination after pick tomato1. Reward:", reward)
                return

            # Step 7: Place tomato1 on plate
            print("[Step 7] Placing tomato1 on plate")
            plate_pos = positions['plate']
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("Early termination after place tomato1. Reward:", reward)
                return

            # Step 8: Pick up tomato2 from table
            print("[Step 8] Picking up tomato2")
            tomato2_pos = positions['tomato2']
            obs, reward, done = pick(env, task, target_pos=tomato2_pos)
            if done:
                print("Early termination after pick tomato2. Reward:", reward)
                return

            # Step 9: Place tomato2 on plate
            print("[Step 9] Placing tomato2 on plate")
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("Task completed early at step 9. Reward:", reward)
            else:
                print("Task completed all steps. Final reward:", reward)

        except Exception as e:
            print("Exception during task execution:", str(e))
            raise
        finally:
            # Always ensure the environment is properly shutdown
            shutdown_environment(env)

        print("===== End of Skeleton Task =====")


    if __name__ == "__main__":
        run_skeleton_task()