[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Helper: get a quaternion target from a named angle object
        def get_quat(name):
            shape = Shape(name)
            return np.array(shape.get_quaternion())

        # === Execute Oracle Plan ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: rotate to ninety_deg")
        target_quat = get_quat('ninety_deg')
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Plan] Task ended early after rotate. Reward:", reward)
            return

        # Step 2: Move to side position of middle drawer
        print("[Plan] Step 2: move to side_pos_middle")
        side_pos = np.array(positions['side_pos_middle'])
        obs, reward, done = move(env, task, target_pos=side_pos)
        if done:
            print("[Plan] Task ended early after move-to-side. Reward:", reward)
            return

        # Step 3: Move to anchor position of middle drawer
        print("[Plan] Step 3: move to anchor_pos_middle")
        anchor_pos = np.array(positions['anchor_pos_middle'])
        obs, reward, done = move(env, task, target_pos=anchor_pos)
        if done:
            print("[Plan] Task ended early after move-to-anchor. Reward:", reward)
            return

        # Step 4: Pick the drawer handle (pick-drawer)
        print("[Plan] Step 4: pick-drawer at anchor_pos_middle")
        obs, reward, done = pick(env, task, target_pos=anchor_pos)
        if done:
            print("[Plan] Task ended early after pick-drawer. Reward:", reward)
            return

        # Step 5: Pull the drawer open
        print("[Plan] Step 5: pull drawer handle")
        # Here we assume pulling along the x-axis by 0.05m; adjust if needed
        obs, reward, done = pull(env, task, pull_distance=0.05, pull_axis='x')
        if done:
            print("[Plan] Task ended early after pull. Reward:", reward)
            return

        # Step 6-9: Pick each tomato from table and place on plate
        for tomato in ['tomato1', 'tomato2']:
            print(f"[Plan] Picking {tomato} from table")
            tom_pos = np.array(positions[tomato])
            obs, reward, done = pick(env, task, target_pos=tom_pos)
            if done:
                print(f"[Plan] Task ended early after picking {tomato}. Reward:", reward)
                return

            print(f"[Plan] Placing {tomato} on plate")
            plate_pos = np.array(positions['plate'])
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print(f"[Plan] Task ended early after placing {tomato}. Reward:", reward)
                return

        print("[Plan] Oracle plan completed. Final reward:", reward)
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
