[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Choose the drawer to open (bottom)
        drawer = 'bottom'
        side_pos_key = f"{drawer}_side_pos"
        anchor_pos_key = f"{drawer}_anchor_pos"
        side_pos = positions[side_pos_key]
        anchor_pos = positions[anchor_pos_key]
        plate_pos = positions['plate']
        # Tomatoes on the table
        tomato_keys = ['item1', 'item2']

        # === Execute Oracle Plan ===
        # Step 1: Rotate gripper to 90 degrees about x-axis
        print("[Plan] Step 1: rotate to ninety_deg")
        target_quat = R.from_euler('x', 90, degrees=True).as_quat()  # xyzw
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Terminated after rotate.")
            return

        # Step 2: Move to side position of drawer
        print(f"[Plan] Step 2: move to {side_pos_key} at {side_pos}")
        obs, reward, done = move(env, task, np.array(side_pos))
        if done:
            print("[Task] Terminated after move to side position.")
            return

        # Step 3: Move to anchor position of drawer handle
        print(f"[Plan] Step 3: move to {anchor_pos_key} at {anchor_pos}")
        obs, reward, done = move(env, task, np.array(anchor_pos))
        if done:
            print("[Task] Terminated after move to anchor position.")
            return

        # Step 4: Pull drawer open
        print("[Plan] Step 4: pull drawer open")
        pull_distance = 0.1  # meters
        obs, reward, done = pull(env, task, pull_distance, pull_axis='x')
        if done:
            print("[Task] Terminated after pull.")
            return

        # Steps 5–8: Pick each tomato and place on plate
        step = 5
        for key in tomato_keys:
            print(f"[Plan] Step {step}: pick {key} at {positions[key]}")
            obs, reward, done = pick(env, task, np.array(positions[key]))
            if done:
                print(f"[Task] Terminated after pick of {key}.")
                return
            step += 1

            print(f"[Plan] Step {step}: place {key} on plate at {plate_pos}")
            obs, reward, done = place(env, task, np.array(plate_pos))
            if done:
                print(f"[Task] Terminated after place of {key}.")
                return
            step += 1

        print("[Task] Completed all plan steps. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()