[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map required object positions
        # Adjust keys to match your environment's naming conventions
        tomato1_pos      = positions.get('tomato1')    or positions.get('item1')
        tomato2_pos      = positions.get('tomato2')    or positions.get('item2')
        table_pos        = positions.get('table')
        plate_pos        = positions.get('plate')
        side_pos_middle  = positions.get('middle_side_pos')   or positions.get('side_pos_middle')
        anchor_pos_middle= positions.get('middle_anchor_pos') or positions.get('anchor_pos_middle')

        if tomato1_pos is None or tomato2_pos is None or table_pos is None or plate_pos is None \
           or side_pos_middle is None or anchor_pos_middle is None:
            raise RuntimeError("Failed to find one or more required object positions in environment.")

        # === Oracle Plan Execution ===

        # Step 1: Rotate the gripper from zero_deg to ninety_deg
        print("[Step 1] Rotating gripper to 90 degrees")
        # Compute target quaternion for a 90° rotation around the Y-axis
        target_quat = R.from_euler('y', 90, degrees=True).as_quat()
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Step 1] Task ended prematurely during rotation.")
            return

        # Step 2: Move to the side position of the middle drawer
        print("[Step 2] Moving to side position of middle drawer")
        obs, reward, done = move(env, task, side_pos_middle)
        if done:
            print("[Step 2] Task ended prematurely during move to side position.")
            return

        # Step 3: Move to the anchor position of the middle drawer
        print("[Step 3] Moving to anchor position of middle drawer")
        obs, reward, done = move(env, task, anchor_pos_middle)
        if done:
            print("[Step 3] Task ended prematurely during move to anchor position.")
            return

        # Step 4: Pull to open/unlock the middle drawer
        print("[Step 4] Pulling drawer to unlock/open")
        # Use a modest pull distance; adjust if needed for your environment
        pull_distance = 0.15
        obs, reward, done = pull(env, task, pull_distance, pull_axis='x')
        if done:
            print("[Step 4] Task ended prematurely during pull.")
            return

        # Step 5: Pick up the first tomato from the table
        print("[Step 5] Picking up tomato1 from the table")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Step 5] Task ended prematurely during pick(tomato1).")
            return

        # Step 6: Place the first tomato onto the plate
        print("[Step 6] Placing tomato1 onto the plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Step 6] Task ended prematurely during place(tomato1).")
            return

        # Step 7: Pick up the second tomato from the table
        print("[Step 7] Picking up tomato2 from the table")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Step 7] Task ended prematurely during pick(tomato2).")
            return

        # Step 8: Place the second tomato onto the plate
        print("[Step 8] Placing tomato2 onto the plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Step 8] Task ended prematurely during place(tomato2).")
            return

        # Final state check
        print("===== Task Plan Executed. Checking goal state =====")
        # You can add any goal verification here if desired (e.g., ensure both tomatoes on plate)
        print("Task completed. Final reward:", reward)

    except Exception as e:
        print("Error during task execution:", str(e))
        raise
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
