[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Define Orientations for rotate step ===
        zero_quat = R.from_euler('z', [0], degrees=True).as_quat()
        ninety_quat = R.from_euler('z', [90], degrees=True).as_quat()

        # === Oracle Plan Execution ===

        # Step 1: rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: Rotate gripper to 90 degrees around Z")
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("Early termination after rotate.")
            return

        # Step 2: move-to-side (approach side position of bottom drawer)
        print("[Plan] Step 2: Move to side position of bottom drawer")
        side_pos = positions['bottom_side_pos']
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("Early termination after move-to-side.")
            return

        # Step 3: move-to-anchor (approach anchor position of bottom drawer)
        print("[Plan] Step 3: Move to anchor position of bottom drawer")
        anchor_pos = positions['bottom_anchor_pos']
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("Early termination after move-to-anchor.")
            return

        # Step 4: pick-drawer (grab the drawer handle)
        print("[Plan] Step 4: Pick the drawer handle at anchor position")
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("Early termination after pick-drawer.")
            return

        # Step 5: pull (open the drawer)
        print("[Plan] Step 5: Pull to open the drawer")
        # assume a small pull distance along the X axis
        drawer_pull_distance = 0.1
        obs, reward, done = pull(env, task, drawer_pull_distance, pull_axis='x')
        if done:
            print("Early termination after pull.")
            return

        # Step 6: pick tomato1 from the table
        print("[Plan] Step 6: Pick tomato1 from table")
        tomato1_pos = positions['tomato1']
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("Early termination after picking tomato1.")
            return

        # Step 7: place tomato1 onto the plate
        print("[Plan] Step 7: Place tomato1 onto plate")
        plate_pos = positions['plate']
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("Early termination after placing tomato1.")
            return

        # Step 8: pick tomato2 from the table
        print("[Plan] Step 8: Pick tomato2 from table")
        tomato2_pos = positions['tomato2']
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("Early termination after picking tomato2.")
            return

        # Step 9: place tomato2 onto the plate
        print("[Plan] Step 9: Place tomato2 onto plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("Early termination after placing tomato2.")
            return

        print("Task completed successfully! Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
