[Frozen Code Start]

[Frozen Code End]

import numpy as np
from scipy.spatial.transform import Rotation as R

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===
        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: rotate gripper zero_deg -> ninety_deg")
        zero_quat = R.from_euler('z', 0, degrees=True).as_quat()
        ninety_quat = R.from_euler('z', 90, degrees=True).as_quat()
        try:
            obs, reward, done = rotate(env, task, target_quat=ninety_quat)
            if done:
                print("[Plan] Terminated after rotation. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Rotation failed: {e}")
            return

        # Step 2: Move to bottom side position
        print("[Plan] Step 2: move to bottom_side_pos")
        try:
            side_pos = np.array(positions['bottom_side_pos'])
            obs, reward, done = move(env, task, target_pos=side_pos)
            if done:
                print("[Plan] Terminated after moving to side. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Move-to-side failed: {e}")
            return

        # Step 3: Move to bottom anchor position
        print("[Plan] Step 3: move to bottom_anchor_pos")
        try:
            anchor_pos = np.array(positions['bottom_anchor_pos'])
            obs, reward, done = move(env, task, target_pos=anchor_pos)
            if done:
                print("[Plan] Terminated after moving to anchor. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Move-to-anchor failed: {e}")
            return

        # Step 4: Pick the drawer handle at anchor position
        print("[Plan] Step 4: pick drawer handle")
        try:
            obs, reward, done = pick(env, task, target_pos=anchor_pos)
            if done:
                print("[Plan] Terminated after picking drawer. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Pick-drawer failed: {e}")
            return

        # Step 5: Pull the drawer to open
        print("[Plan] Step 5: pull drawer open")
        try:
            # Assuming pulling along +x by 0.1 m opens the drawer
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
            if done:
                print("[Plan] Terminated after pull. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Pull failed: {e}")
            return

        # Step 6: Pick tomato1 from the table
        print("[Plan] Step 6: pick tomato1")
        try:
            tomato1_pos = np.array(positions['tomato1'])
            obs, reward, done = pick(env, task, target_pos=tomato1_pos)
            if done:
                print("[Plan] Terminated after picking tomato1. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Pick tomato1 failed: {e}")
            return

        # Step 7: Place tomato1 onto the plate
        print("[Plan] Step 7: place tomato1 on plate")
        try:
            plate_pos = np.array(positions['plate'])
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("[Plan] Terminated after placing tomato1. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Place tomato1 failed: {e}")
            return

        # Step 8: Pick tomato2 from the table
        print("[Plan] Step 8: pick tomato2")
        try:
            tomato2_pos = np.array(positions['tomato2'])
            obs, reward, done = pick(env, task, target_pos=tomato2_pos)
            if done:
                print("[Plan] Terminated after picking tomato2. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Pick tomato2 failed: {e}")
            return

        # Step 9: Place tomato2 onto the plate
        print("[Plan] Step 9: place tomato2 on plate")
        try:
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("[Plan] Terminated after placing tomato2. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] Place tomato2 failed: {e}")
            return

        # Task completed
        print("===== Plan executed successfully! Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()