[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import pick, place, move, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Task logic for opening a drawer and tossing two tomatoes onto a plate.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Expected keys in positions:
        #   'ninety_deg', 'bottom_side_pos', 'bottom_anchor_pos',
        #   'tomato1', 'tomato2', 'plate'

        # ==== Oracle Plan Execution ====

        # Step 1: Rotate gripper to ninety_deg orientation
        print("[Plan] Step 1: rotate to ninety_deg")
        obs, reward, done = rotate(
            env,
            task,
            target_quat=positions['ninety_deg']
        )
        if done:
            print("[Plan] Terminated after rotate.")
            return

        # Step 2: Move gripper to side position of bottom drawer
        print("[Plan] Step 2: move to bottom side position")
        obs, reward, done = move(
            env,
            task,
            target_pos=positions['bottom_side_pos']
        )
        if done:
            print("[Plan] Terminated after move to side.")
            return

        # Step 3: Move gripper to anchor position of bottom drawer
        print("[Plan] Step 3: move to bottom anchor position")
        obs, reward, done = move(
            env,
            task,
            target_pos=positions['bottom_anchor_pos']
        )
        if done:
            print("[Plan] Terminated after move to anchor.")
            return

        # Step 4: Pull drawer open
        print("[Plan] Step 4: pull to open bottom drawer")
        obs, reward, done = pull(
            env,
            task,
            pull_distance=0.15,
            pull_axis='x'
        )
        if done:
            print("[Plan] Terminated after pull.")
            return

        # Step 5: Pick tomato1 from the table
        print("[Plan] Step 5: pick tomato1 from table")
        obs, reward, done = pick(
            env,
            task,
            target_pos=positions['tomato1'],
            approach_distance=0.15,
            approach_axis='z'
        )
        if done:
            print("[Plan] Terminated after pick tomato1.")
            return

        # Step 6: Place tomato1 onto the plate
        print("[Plan] Step 6: place tomato1 on plate")
        obs, reward, done = place(
            env,
            task,
            target_pos=positions['plate'],
            approach_distance=0.15,
            approach_axis='z'
        )
        if done:
            print("[Plan] Terminated after place tomato1.")
            return

        # Step 7: Pick tomato2 from the table
        print("[Plan] Step 7: pick tomato2 from table")
        obs, reward, done = pick(
            env,
            task,
            target_pos=positions['tomato2'],
            approach_distance=0.15,
            approach_axis='z'
        )
        if done:
            print("[Plan] Terminated after pick tomato2.")
            return

        # Step 8: Place tomato2 onto the plate
        print("[Plan] Step 8: place tomato2 on plate")
        obs, reward, done = place(
            env,
            task,
            target_pos=positions['plate'],
            approach_distance=0.15,
            approach_axis='z'
        )
        if done:
            print("[Plan] Terminated after place tomato2.")
            return

        # Final check
        if not done:
            print("[Plan] Completed all steps. Final reward:", reward)

    except Exception as e:
        print(f"[Error] Exception during plan execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()