import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)

        # wrap step and observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # retrieve object positions
        positions = get_object_positions()
        side_pos = positions['bottom_side_pos']
        anchor_pos = positions['bottom_anchor_pos']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # Step 1: rotate gripper to 90° around Z
        print("[Task] Rotating gripper to 90° around Z")
        target_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])

        # === Frozen Code Start ===
        obs, reward, done = rotate(env, task, target_quat)
        obs, reward, done = move(env, task, side_pos)
        obs, reward, done = move(env, task, anchor_pos)
        obs, reward, done = pick(env, task, anchor_pos)
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        obs, reward, done = pick(env, task, tomato1_pos)
        obs, reward, done = place(env, task, plate_pos)
        # === Frozen Code End ===

        if done:
            print("[Task] Terminated after placing tomato1. Reward:", reward)
            return

        # Step 8: pick tomato2
        print("[Task] Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Terminated after picking tomato2. Reward:", reward)
            return

        # Step 9: place tomato2 on plate
        print("[Task] Placing tomato2 on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Terminated after placing tomato2. Reward:", reward)
            return

        # all steps done
        print("[Task] Plan executed successfully. Final reward:", reward)

    except Exception as e:
        print("[Error] Exception during task execution:", str(e))
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()