[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

# This module is assumed to provide object positions or other info about the environment
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Map names to keys used in object_positions
        # drawer handle positions
        side_bottom_key = 'bottom_side_pos'
        anchor_bottom_key = 'bottom_anchor_pos'
        tomato1_key = 'tomato1'
        tomato2_key = 'tomato2'
        plate_key = 'plate'

        # === Oracle Plan Execution ===
        # Step 1: rotate gripper from zero_deg to ninety_deg
        # Compute quaternion for a 90° rotation about Z axis
        target_quat = normalize_quaternion(R.from_euler('z', 90, degrees=True).as_quat())
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Ended after rotate.")
            return

        # Step 2: move to side position of bottom drawer
        side_pos = positions[side_bottom_key]
        obs, reward, done = move(env, task, target_pos=np.array(side_pos))
        if done:
            print("[Task] Ended after move-to-side.")
            return

        # Step 3: move to anchor position of bottom drawer
        anchor_pos = positions[anchor_bottom_key]
        obs, reward, done = move(env, task, target_pos=np.array(anchor_pos))
        if done:
            print("[Task] Ended after move-to-anchor.")
            return

        # Step 4: pick the drawer handle (treat as pick operation)
        obs, reward, done = pick(env, task, target_pos=np.array(anchor_pos))
        if done:
            print("[Task] Ended after pick-drawer.")
            return

        # Step 5: pull the drawer open along X axis by a fixed distance
        pull_distance = 0.1  # meters
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Task] Ended after pull.")
            return

        # Step 6: pick tomato1 from the table
        pos_t1 = positions[tomato1_key]
        obs, reward, done = pick(env, task, target_pos=np.array(pos_t1))
        if done:
            print("[Task] Ended after pick tomato1.")
            return

        # Step 7: place tomato1 onto the plate
        pos_plate = positions[plate_key]
        obs, reward, done = place(env, task, target_pos=np.array(pos_plate))
        if done:
            print("[Task] Ended after place tomato1.")
            return

        # Step 8: pick tomato2 from the table
        pos_t2 = positions[tomato2_key]
        obs, reward, done = pick(env, task, target_pos=np.array(pos_t2))
        if done:
            print("[Task] Ended after pick tomato2.")
            return

        # Step 9: place tomato2 onto the plate
        obs, reward, done = place(env, task, target_pos=np.array(pos_plate))
        if done:
            print("[Task] Ended after place tomato2. Task complete.")
        else:
            print("[Task] Task completed steps but done flag is False. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
