[Frozen Code Start]
    obs, reward, done = rotate(env, task, target_quat)
[Frozen Code End]

        # Step 2: Move to drawer side position
        side_pos = np.array(positions['bottom_side_pos'])
        print(f"[Task] Moving to drawer side position: {side_pos}")
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Task] Task ended during move-to-side step.")
            return

        # Step 3: Move to drawer anchor position
        anchor_pos = np.array(positions['bottom_anchor_pos'])
        print(f"[Task] Moving to drawer anchor position: {anchor_pos}")
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Task] Task ended during move-to-anchor step.")
            return

        # Step 4: Pick the drawer handle
        print(f"[Task] Picking drawer handle at: {anchor_pos}")
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Task] Task ended during pick-drawer step.")
            return

        # Step 5: Pull the drawer open
        print("[Task] Pulling drawer to open it")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Task ended during pull step.")
            return

        # Step 6: Pick the first tomato
        tomato1_pos = np.array(positions['tomato1'])
        print(f"[Task] Picking first tomato at: {tomato1_pos}")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Task ended during pick(tomato1).")
            return

        # Step 7: Place the first tomato on the plate
        plate_pos = np.array(positions['plate'])
        print(f"[Task] Placing first tomato on plate at: {plate_pos}")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task ended during place(tomato1).")
            return

        # Step 8: Pick the second tomato
        tomato2_pos = np.array(positions['tomato2'])
        print(f"[Task] Picking second tomato at: {tomato2_pos}")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Task ended during pick(tomato2).")
            return

        # Step 9: Place the second tomato on the plate
        print(f"[Task] Placing second tomato on plate at: {plate_pos}")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task ended during place(tomato2).")
            return
        else:
            print(f"[Task] Completed all steps. Final reward: {reward}, done={done}")

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()