        if done:
            print("[Task] ended unexpectedly at step 1.")
            return

        # Step 2: Move to the side position of the drawer
        print(f"[Step 2] Move to drawer side position: {side_pos}")
        obs, reward, done = move(env, task, target_pos=np.array(side_pos))
        if done:
            print("[Task] ended unexpectedly at step 2.")
            return

        # Step 3: Move to the anchor position of the drawer
        print(f"[Step 3] Move to drawer anchor position: {anchor_pos}")
        obs, reward, done = move(env, task, target_pos=np.array(anchor_pos))
        if done:
            print("[Task] ended unexpectedly at step 3.")
            return

        # Step 4: Pick the drawer handle
        print("[Step 4] Pick drawer handle")
        obs, reward, done = pick(env, task, target_pos=np.array(anchor_pos))
        if done:
            print("[Task] ended unexpectedly at step 4.")
            return

        # Step 5: Pull the drawer open
        print("[Step 5] Pull drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] ended unexpectedly at step 5.")
            return

        # Step 6: Pick tomato1 from the table
        print(f"[Step 6] Pick tomato1 at {tomato1_pos}")
        obs, reward, done = pick(env, task, target_pos=np.array(tomato1_pos))
        if done:
            print("[Task] ended unexpectedly at step 6.")
            return

        # Step 7: Place tomato1 on the plate
        print(f"[Step 7] Place tomato1 on plate at {plate_pos}")
        obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
        if done:
            print("[Task] ended unexpectedly at step 7.")
            return

        # Step 8: Pick tomato2 from the table
        print(f"[Step 8] Pick tomato2 at {tomato2_pos}")
        obs, reward, done = pick(env, task, target_pos=np.array(tomato2_pos))
        if done:
            print("[Task] ended unexpectedly at step 8.")
            return

        # Step 9: Place tomato2 on the plate
        print(f"[Step 9] Place tomato2 on plate at {plate_pos}")
        obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
        if done:
            print("[Task] ended unexpectedly at step 9.")
            return

        print("[Task] All tomatoes have been placed on the plate. Final reward:", reward)

    finally:
        shutdown_environment(env)
        print("===== End of Combined Task =====")

if __name__ == "__main__":
    run_skeleton_task()