[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Execute oracle plan: open bottom drawer and place two tomatoes onto the plate.'''
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # wrap step and observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions from perception module
        positions = get_object_positions()
        # Expected keys in positions dict:
        #   'bottom_side_pos', 'bottom_anchor_pos', 'tomato1', 'tomato2', 'plate'

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: Rotating gripper to 90 degrees")
        # Build target quaternion for 90° about the Y axis
        half = np.sin(np.pi/4)
        target_quat = np.array([0.0, half, 0.0, np.cos(np.pi/4)])
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Terminated after rotate, reward:", reward)
            return

        # Step 2: Move to side position of bottom drawer
        print("[Task] Step 2: Moving to bottom side position")
        side_pos = positions['bottom_side_pos']
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Task] Terminated after move-to-side, reward:", reward)
            return

        # Step 3: Move to anchor position of bottom drawer
        print("[Task] Step 3: Moving to bottom anchor position")
        anchor_pos = positions['bottom_anchor_pos']
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Task] Terminated after move-to-anchor, reward:", reward)
            return

        # Step 4: Pick the drawer handle at anchor position
        print("[Task] Step 4: Picking drawer handle")
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Task] Terminated after pick-drawer, reward:", reward)
            return

        # Step 5: Pull the drawer open along +x axis by 0.1 m
        print("[Task] Step 5: Pulling the drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Terminated after pull, reward:", reward)
            return

        # Step 6: Pick tomato1 from the table
        print("[Task] Step 6: Picking tomato1")
        pos_t1 = positions['tomato1']
        obs, reward, done = pick(env, task, pos_t1)
        if done:
            print("[Task] Terminated after pick tomato1, reward:", reward)
            return

        # Step 7: Place tomato1 onto the plate
        print("[Task] Step 7: Placing tomato1 onto plate")
        plate_pos = positions['plate']
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Terminated after place tomato1, reward:", reward)
            return

        # Step 8: Pick tomato2 from the table
        print("[Task] Step 8: Picking tomato2")
        pos_t2 = positions['tomato2']
        obs, reward, done = pick(env, task, pos_t2)
        if done:
            print("[Task] Terminated after pick tomato2, reward:", reward)
            return

        # Step 9: Place tomato2 onto the plate
        print("[Task] Step 9: Placing tomato2 onto plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Completed after place tomato2, reward:", reward)
        else:
            print("[Task] All steps executed. Final reward:", reward)

    except Exception as e:
        print("[Task] Exception during execution:", str(e))
    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()