[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # 1) Rotate gripper from zero_deg to ninety_deg
        print("[Task] Rotating gripper to ninety_deg")
        zero_quat = positions.get('zero_deg')
        ninety_quat = positions.get('ninety_deg')
        if zero_quat is None or ninety_quat is None:
            raise KeyError("Angle quaternions 'zero_deg' or 'ninety_deg' not found in positions.")
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        if done:
            print("[Task] Finished early after rotate. Reward:", reward)
            return

        # 2) Move to side position of bottom drawer
        print("[Task] Moving to side position of bottom drawer")
        side_pos_bottom = positions.get('bottom_side_pos')
        if side_pos_bottom is None:
            raise KeyError("'bottom_side_pos' not found in positions.")
        obs, reward, done = move(env, task, target_pos=np.array(side_pos_bottom))
        if done:
            print("[Task] Finished early after move-to-side. Reward:", reward)
            return

        # 3) Move to anchor position of bottom drawer
        print("[Task] Moving to anchor position of bottom drawer")
        anchor_pos_bottom = positions.get('bottom_anchor_pos')
        if anchor_pos_bottom is None:
            raise KeyError("'bottom_anchor_pos' not found in positions.")
        obs, reward, done = move(env, task, target_pos=np.array(anchor_pos_bottom))
        if done:
            print("[Task] Finished early after move-to-anchor. Reward:", reward)
            return

        # 4) Pick the drawer handle at anchor position
        print("[Task] Picking drawer handle")
        obs, reward, done = pick(env, task, target_pos=np.array(anchor_pos_bottom))
        if done:
            print("[Task] Finished early after pick-drawer. Reward:", reward)
            return

        # 5) Pull the drawer open
        print("[Task] Pulling the bottom drawer open")
        # Estimate a reasonable pull distance (e.g., 0.2 meters along x)
        obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
        if done:
            print("[Task] Finished early after pull. Reward:", reward)
            return

        # 6) Pick tomato1 from table
        print("[Task] Picking tomato1 from table")
        tomato1_pos = positions.get('tomato1')
        if tomato1_pos is None:
            raise KeyError("'tomato1' not found in positions.")
        obs, reward, done = pick(env, task, target_pos=np.array(tomato1_pos))
        if done:
            print("[Task] Finished early after pick tomato1. Reward:", reward)
            return

        # 7) Place tomato1 on plate
        print("[Task] Placing tomato1 on plate")
        plate_pos = positions.get('plate')
        if plate_pos is None:
            raise KeyError("'plate' not found in positions.")
        obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
        if done:
            print("[Task] Finished early after place tomato1. Reward:", reward)
            return

        # 8) Pick tomato2 from table
        print("[Task] Picking tomato2 from table")
        tomato2_pos = positions.get('tomato2')
        if tomato2_pos is None:
            raise KeyError("'tomato2' not found in positions.")
        obs, reward, done = pick(env, task, target_pos=np.array(tomato2_pos))
        if done:
            print("[Task] Finished early after pick tomato2. Reward:", reward)
            return

        # 9) Place tomato2 on plate
        print("[Task] Placing tomato2 on plate")
        obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
        if done:
            print("[Task] Finished early after place tomato2. Reward:", reward)
            return

        # Final status
        print("[Task] Completed all plan steps. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()