import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
    
        # === Retrieve Object Positions ===
        positions = get_object_positions()
        print("[Task] Retrieved object positions:", positions)
    
        # Check for drawer handle
        if 'drawer_handle' not in positions:
            print("[Error] 'drawer_handle' not found in environment objects! Aborting task.")
            return
        drawer_handle_pos = positions['drawer_handle']
    
        # === Move to Drawer Handle ===
        print("[Task] Moving to drawer handle at:", drawer_handle_pos)
        try:
            obs, reward, done = move(
                env,
                task,
                target_pos=drawer_handle_pos,
                max_steps=100,
                threshold=0.01,
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] move failed: {e}")
            return
        if done:
            print("[Task] Task ended during move!")
            return
    
        # === Pick Drawer Handle ===
        print("[Task] Picking up drawer handle")
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=drawer_handle_pos,
                approach_distance=0.02,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pick failed: {e}")
            return
        if done:
            print("[Task] Task ended during pick!")
            return
    
        # === Pull Drawer to Learn Lock State ===
        print("[Task] Pulling on drawer handle to identify lock state")
        try:
            obs, reward, done = pull(
                env,
                task,
                target_pos=drawer_handle_pos,
                approach_distance=0.05,
                max_steps=100,
                threshold=0.01,
                approach_axis='x',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pull failed: {e}")
            return
        if done:
            print("[Task] Task ended during pull!")
            return
    
        # === Place Drawer Handle Back ===
        print("[Task] Releasing drawer handle back to original position")
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=drawer_handle_pos,
                approach_distance=0.02,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] place failed: {e}")
            return
        if done:
            print("[Task] Task ended during place!")
            return
    
    finally:
        shutdown_environment(env)
    
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()