import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import pick, place, move, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Example of expected keys: 'ball1', 'ball2', etc.
        # Adjust names according to your actual scene objects
        object_names = ['ball1', 'ball2']
        source_room = 'rooma'
        target_room = 'roomb'

        # === Oracle Plan: Pick each ball from rooma and place into roomb ===
        for obj in object_names:
            obj_pos = positions.get(obj)
            if obj_pos is None:
                print(f"[Task] Warning: Could not find position for object '{obj}'. Skipping.")
                continue

            print(f"[Task] Attempting to pick '{obj}' from {source_room}")
            try:
                obs, reward, done = pick(env, task, obj, source_room)
            except Exception as e:
                print(f"[Task] Error during pick of '{obj}': {e}")
                continue

            if done:
                print("[Task] Task terminated unexpectedly after pick.")
                return

            print(f"[Task] Attempting to place '{obj}' into {target_room}")
            try:
                obs, reward, done = place(env, task, obj, target_room)
            except Exception as e:
                print(f"[Task] Error during place of '{obj}': {e}")
                continue

            if done:
                print("[Task] Task terminated unexpectedly after place.")
                return

        print("[Task] Completed oracle disposal plan.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()