def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects and their positions are known
        gripper = 'gripper'  # Placeholder for the gripper object
        drawer = 'drawer'    # Placeholder for the drawer object
        bottom_position = positions['bottom']  # Position of the bottom of the drawer
        side_position = positions['side']      # Position of the side of the drawer
        anchor_position = positions['anchor']   # Position of the anchor of the drawer

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to side position of the drawer.")
        move(env, 'current_room', side_position)

        # Step 2: Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to ninety degrees.")
        rotate(env, gripper, 'zero_deg', 'ninety_deg')

        # Step 3: Move to the anchor position of the drawer
        print("[Task] Moving to anchor position of the drawer.")
        move(env, side_position, anchor_position)

        # Step 4: Pick the drawer
        print("[Task] Picking the drawer.")
        pick_drawer(env, gripper, drawer, anchor_position)

        # Step 5: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        pull(env, gripper, drawer)

        # Step 6: Move to the bottom position to interact with the object
        print("[Task] Moving to the bottom position.")
        move(env, anchor_position, bottom_position)

        # Step 7: Pick the object at the bottom position
        print("[Task] Picking the object at the bottom position.")
        pick(env, 'object_at_bottom', bottom_position)

        # Step 8: Place the object back at the bottom position
        print("[Task] Placing the object back at the bottom position.")
        place(env, 'object_at_bottom', bottom_position)

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()